%{
This m-file belongs to Chapter 4 of the dissertation 'Electrochemical CO2
conversion with a flow-through copper hollow fibre'
Anne Sustronk (1,2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to prepare Figures 2 and 3 in the chapter

The next files are required to execute this file: ConstantPotentialCO.m
and CalcErr.m

Note that the file location in ConstantPotentialCO.m (lines 46, 73, 78
and 83) should be added before execution of Fig2And3.m.

Brief overview of experimental conditions: Cu hollow fiber working 
electrode, 0.5M KHCO3 or KOH  in MilliQ water, CO purged through fiber,
Ar purged through head space, chronoamperometry

Note that the flow rate to calculate the partial current densities is set
to 30 ml min-1. This is most likely an underestimation of the actual flow
rate at more negative potentials

Note that the formation of formate most likely occurs through a chemical 
rather than an electrochemical reaction. For this reason the concentration
FA is calculated

Version date m-file: March 22, 2023
%}

clear all, clc, close all

%% Size for figure

size = 6;       % Width (in cm)


%% File location and name

%% Input data CO flow through experiments in KOH

% Retrieve file paths
KOH.COThrough.Folder1 = '\CO flow through\KOH';
KOH.COThrough.Folder2 = {'\-1.3V';'\-1.4V';'\-1.5V';'\-1.7V';'\-1.8V';'\-2.0V';'\-2.1V';'\-2.4V';'\-2.8V'};

% Retrieve file names potentiostat data
KOH.COThrough.FileNameEC = {'\Fiber221024-2 KOH FT CO -1_3V_03_CA_C08.txt';
    '\Fiber220831-3 KOH FT CO -1_4V_03_CA_C08.txt';
    '\Fiber220831-1 KOH FT CO -1_5V_03_CA_C08.txt';
    '\Fiber220831-3 KOH FT CO -1_7V_03_CA_C08.txt';
    '\Fiber220831-1 KOH FT CO -1_8V_03_CA_C08.txt';
    '\Fiber220831-3 KOH FT CO -2_0V_03_CA_C08.txt';
    '\Fiber220831-1 KOH FT CO -2_1V_03_CA_C08.txt';
    '\Fiber221024-4 KOH FT -2_4V_03_CA_C08_corrected.txt'};

% Geometric area (cm^2)
KOH.COThrough.Area(1,1) = 1.023*mean([0.150 0.146])*pi();

KOH.COThrough.Area(2,1) = 1.080*mean([0.152 0.149])*pi();
KOH.COThrough.Area(4,1) = KOH.COThrough.Area(2,1);
KOH.COThrough.Area(6,1) = KOH.COThrough.Area(2,1);

KOH.COThrough.Area(3,1) = 0.925*mean([0.148 0.146])*pi();
KOH.COThrough.Area(5,1) = KOH.COThrough.Area(3,1);
KOH.COThrough.Area(7,1) = KOH.COThrough.Area(3,1);

KOH.COThrough.Area(8,1) = 1.089*mean([0.148 0.146])*pi();

% Estimated error in geometric area (cm^2)
KOH.COThrough.AreaErr(1,1) = 0.1*mean([0.150 0.146])*pi();

KOH.COThrough.AreaErr (2,1) = 0.1*mean([0.152 0.149])*pi();
KOH.COThrough.AreaErr(4,1) = KOH.COThrough.AreaErr(2,1);
KOH.COThrough.AreaErr(6,1) = KOH.COThrough.AreaErr(2,1);

KOH.COThrough.AreaErr(3,1) = 0.1*mean([0.148 0.146])*pi();
KOH.COThrough.AreaErr(5,1) = KOH.COThrough.AreaErr(3,1);
KOH.COThrough.AreaErr(7,1) = KOH.COThrough.AreaErr(3,1);

KOH.COThrough.AreaErr(8,1) = 0.1*mean([0.148 0.146])*pi();

% Set variable name
KOH.COThrough.VarName = ['Exp01'; 'Exp02'; 'Exp03'; 'Exp04';'Exp05'; 'Exp06';'Exp07'; 'Exp08'];

% Uncorrected potential used during chronoamperometry
KOH.COThrough.ESet = [-1.3; -1.4; -1.5; -1.7; -1.8; -2.0; -2.1; -2.4];

% Volume catholyte and flow rate to gas chromatograph
KOH.COThrough.VCat = 65/1000*ones(8,1); % (L)
KOH.COThrough.FlowRate = 30/60*ones(8,1); % (mL/s)

% Call ConstantPotentialCO.m
KOH.COThrough = ConstantPotentialCO(KOH.COThrough);

% Recalculate potential from Hg/HgO to Ag/AgCl
KOH.COThrough.Ereal(:,1) = KOH.COThrough.Ereal(:,1)-0.077;

%% Input data CO flow through experiments in KHCO3

% Retrieve file paths
KHCO3.COThrough.Folder1 = '\CO flow through\KHCO3';
KHCO3.COThrough.Folder2 = {'\-1.3V';'\-1.4V'; '\-1.5V';'\-1.6V';'\-1.7V'; '\-1.8V';'\-1.9V';'\-2.0V';'\-2.2V'; '\-2.8V';'\-3.2V'};

% Retrieve file names potentiostat data
KHCO3.COThrough.FileNameEC = {'\Fiber220707-1 CO flow KHCO3 -1_3V_03_CA_C08.txt';
    '\Fiber220831-5 KHCO3 CO flow through -1_4V_03_CA_C08.txt';
    '\Fiber220831-4 KHCO3 CO flow through -1_5V_03_CA_C08.txt';
    '\Fiber220707-1 CO flow KHCO3 -1_6V_03_CA_C08.txt';
    '\Fiber220831-5 KHCO3 CO flow through -1_7V_03_CA_C08.txt';
    '\Fiber220831-4 KHCO3 CO flow through -1_8V_03_CA_C08.txt';
    '\Fiber220707-1 CO flow KHCO3 -1_9V_03_CA_C08.txt';
    '\Fiber220831-5 KHCO3 CO flow through -2_0V_03_CA_C08.txt';
    '\Fiber220831-4 KHCO3 CO flow through -2_2V_03_CA_C08.txt';
    '\Fiber221027-1 CO FT KHCO3 -2_8 V vs Ag_AgCl_03_CA_C08.txt';
    '\Fiber221027-1 CO FT KHCO3 -3_2V vs Ag_AgCl_03_CA_C08.txt'};

% Geometric area (cm^2)
KHCO3.COThrough.Area(1,1) = 1.239*mean([0.149 0.147])*pi();
KHCO3.COThrough.Area(4,1) = KHCO3.COThrough.Area(1,1);
KHCO3.COThrough.Area(7,1) = KHCO3.COThrough.Area(1,1);

KHCO3.COThrough.Area(2,1) = 0.962*mean([0.148 0.151])*pi();
KHCO3.COThrough.Area(5,1) = KHCO3.COThrough.Area(2,1);
KHCO3.COThrough.Area(8,1) = KHCO3.COThrough.Area(2,1);

KHCO3.COThrough.Area(3,1) = 0.894*mean([0.147 0.148])*pi();
KHCO3.COThrough.Area(6,1) = KHCO3.COThrough.Area(3,1);
KHCO3.COThrough.Area(9,1) = KHCO3.COThrough.Area(3,1);

KHCO3.COThrough.Area(10,1) = 1.004*mean([0.148 0.149])*pi();
KHCO3.COThrough.Area(11,1) = KHCO3.COThrough.Area(10,1);

% Estimated error in geometric area (cm^2)
KHCO3.COThrough.AreaErr(1,1) = 0.1*mean([0.149 0.147])*pi();
KHCO3.COThrough.AreaErr(4,1) = KHCO3.COThrough.AreaErr(1,1);
KHCO3.COThrough.AreaErr(7,1) = KHCO3.COThrough.AreaErr(1,1);

KHCO3.COThrough.AreaErr(2,1) = 0.1*mean([0.148 0.151])*pi();
KHCO3.COThrough.AreaErr(5,1) = KHCO3.COThrough.AreaErr(2,1);
KHCO3.COThrough.AreaErr(8,1) = KHCO3.COThrough.AreaErr(2,1);

KHCO3.COThrough.AreaErr(3,1) = 0.1*mean([0.147 0.148])*pi();
KHCO3.COThrough.AreaErr(6,1) = KHCO3.COThrough.AreaErr(3,1);
KHCO3.COThrough.AreaErr(9,1) = KHCO3.COThrough.AreaErr(3,1);

KHCO3.COThrough.AreaErr(10,1) = 0.1*mean([0.148 0.149])*pi();
KHCO3.COThrough.AreaErr(11,1) = KHCO3.COThrough.AreaErr(10,1);

% Set variable name
KHCO3.COThrough.VarName = ['Exp01'; 'Exp02'; 'Exp03'; 'Exp04';'Exp05';'Exp06';'Exp07';'Exp08';'Exp09';'Exp10';'Exp11'];

% Uncorrected potential used during chronoamperometry
KHCO3.COThrough.ESet = [-1.3; -1.4; -1.5; -1.6; -1.7; -1.8; -1.9; -2.0; -2.2; -2.8; -3.2];

% Volume catholyte and flow rate to gas chromatograph
KHCO3.COThrough.VCat = 50/1000*ones(11,1);      % (L)
KHCO3.COThrough.FlowRate = 30/60*ones(11,1);    % (ml/s)

% Call ConstantPotential CO.m
KHCO3.COThrough = ConstantPotentialCO(KHCO3.COThrough);

%% Plot results for Figures 2 and 3

% C based products for KHCO3 and KOH
PlotPCDCAll(KHCO3.COThrough,KHCO3.COThrough, 401, [-1.8 -0.8 -50 0],linspace(-1.8,-0.8,6),linspace(-50,0,6), 'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)
PlotPCDCAll(KOH.COThrough,KOH.COThrough, 402, [-1.8 -0.8 -50 0],linspace(-1.8,-0.8,6),linspace(-50,0,6), 'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)

% H and total current density for KHCO3 and KOH
PlotPCDH2All(KHCO3.COThrough,KHCO3.COThrough, 403, [-1.8 -0.8 -500 0],linspace(-1.8,-0.8,6),linspace(-500,0,6), 'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)
PlotPCDH2All(KOH.COThrough,KOH.COThrough, 404, [-1.8 -0.8 -500 0],linspace(-1.8,-0.8,6),linspace(-500,0,6), 'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)


%% Other plots

% Current density that is not assigned

PlotPCD(KHCO3.COThrough, KHCO3.COThrough.CDUnaccounted, '*b', 108, KHCO3.COThrough.ESet, [-1.7 -1.1 -100 0],linspace(-1.7,-1.1,4),linspace(-100,0,5), 'E_{real} (V vs Ag/AgCl)',{'CD_{Unaccounted}';'(mA cm^{-2}_{geo})'},size)
PlotPCD(KOH.COThrough, KOH.COThrough.CDUnaccounted, 'ok', 109, KOH.COThrough.ESet, [-1.7 -1.1 -100 0],linspace(-1.7,-1.1,4),linspace(-100,0,5), 'E_{real} (V vs Ag/AgCl)',{'CD_{Unaccounted}';'(mA cm^{-2}_{geo})'},size)


% Current versus time KHCO3 electrolyte
figure(501);
hold on
for i = length(KHCO3.COThrough.ESet)
    plot(KHCO3.COThrough.Exp01.t,KHCO3.COThrough.Exp01.I)
    plot(KHCO3.COThrough.Exp02.t,KHCO3.COThrough.Exp02.I)
    plot(KHCO3.COThrough.Exp03.t,KHCO3.COThrough.Exp03.I)
    plot(KHCO3.COThrough.Exp04.t,KHCO3.COThrough.Exp04.I)
    plot(KHCO3.COThrough.Exp05.t,KHCO3.COThrough.Exp05.I)
    plot(KHCO3.COThrough.Exp06.t,KHCO3.COThrough.Exp06.I)
    plot(KHCO3.COThrough.Exp07.t,KHCO3.COThrough.Exp07.I)
    plot(KHCO3.COThrough.Exp08.t,KHCO3.COThrough.Exp08.I)
    plot(KHCO3.COThrough.Exp09.t,KHCO3.COThrough.Exp09.I)
    plot(KHCO3.COThrough.Exp10.t,KHCO3.COThrough.Exp10.I)
    plot(KHCO3.COThrough.Exp11.t,KHCO3.COThrough.Exp11.I)
end
hold off

% Current versus time KOH
figure(502);
hold on
plot(KOH.COThrough.Exp01.t,KOH.COThrough.Exp01.I)
plot(KOH.COThrough.Exp02.t,KOH.COThrough.Exp02.I)
plot(KOH.COThrough.Exp03.t,KOH.COThrough.Exp03.I)
plot(KOH.COThrough.Exp04.t,KOH.COThrough.Exp04.I)
plot(KOH.COThrough.Exp05.t,KOH.COThrough.Exp05.I)
plot(KOH.COThrough.Exp06.t,KOH.COThrough.Exp06.I)
plot(KOH.COThrough.Exp07.t,KOH.COThrough.Exp07.I)
plot(KOH.COThrough.Exp08.t,KOH.COThrough.Exp08.I)
hold off


%% Function files for plot

% Plot all carbon based products KHCO3 electrolyte
function PlotPCDCAll(x1,y1,FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet)
    errorbar(x1.Ereal(i,1),y1.CDAc(i,1),y1.CDAc(i,2),y1.CDAc(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'vk','color','#000080')
    errorbar(x1.Ereal(i,1),y1.FID_CD(i,2),y1.FID_CD_Err(i,2),y1.FID_CD_Err(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'dm')
    errorbar(x1.Ereal(i,1),y1.CDProp(i,1),y1.CDProp(i,2),y1.CDProp(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'sk')
end
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;
xtickformat('%.1f')

% X and Y lable
xlabel(labelX)
ylabel(labelY)

% Additional figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

% Legend
legend('Acetate','Ethylene','1-Propanol', 'Location','SouthEast')
end

% Plot H2 and total current density
function PlotPCDH2All(x1,y1, FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet)
    errorbar(x1.Ereal(i,1),y1.CDH2(i,1),y1.CDH2(i,2),y1.CDH2(i,2),y1.Ereal(i,2),y1.Ereal(i,2), '<','Color','#008631')
    errorbar(x1.Ereal(i,1),y1.CDavg30mins(i,1),y1.CDavg30mins(i,2),y1.CDavg30mins(i,2),y1.Ereal(i,2),y1.Ereal(i,2),'*k')
end

hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;
xtickformat('%.1f')

% X and Y label
xlabel(labelX)
ylabel(labelY)

% Additional figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

% Legend
legend('H_{2}','Total','Location','SouthEast')
end

% Function to plot unassigned current density versus potential
function PlotPCD(x,y,LineSpec, FigNum, ESet, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(ESet)
    plot(x.Ereal(i,1),y(i,1), LineSpec)
end

hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;
xtickformat('%.1f')

% X and Y label
xlabel(labelX)
ylabel(labelY)

% Additional figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

end